/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.autoworkstations.auto_anvil;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.autoworkstations.auto_anvil.AutoAnvilScreenHandler;
import uk.co.cablepost.autoworkstations.util.TextUtil;

public class AutoAnvilBlockEntity
extends class_2586
implements class_1278,
class_3908 {
    public static int INVENTORY_SIZE = 6;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)INVENTORY_SIZE, (Object)class_1799.field_8037);
    public static int SLOT_EMPTY_BOTTLE = 0;
    public static int SLOT_EXP_BOTTLE = 1;
    public static int SLOT_ITEM_IN = 2;
    public static int SLOT_ITEM_ADD = 3;
    public static int SLOT_ITEM_OUT = 4;
    public static int SLOT_ANVIL = 5;
    int xpEmptyBottleProgress;
    public int xpEmptyBottleMaxProgress = 20;
    int expLevel;
    float expProgress;
    public int processProgress;
    public int maxProcessProgress = 60;
    public static int MODE_REPAIR = 0;
    public static int MODE_RENAME = 1;
    public int mode = MODE_REPAIR;
    public class_1799 result = null;
    public Integer levelCost = null;
    public Integer repairItemUsage = null;
    public class_1799 lastInputStack = null;
    public class_1799 lastAdditionStack = null;
    public int lastMode = -1;
    public Random random;
    public static int PROPERTY_DELEGATE_SIZE = 8;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return Math.round(AutoAnvilBlockEntity.this.expProgress * 100.0f);
                }
                case 1: {
                    return AutoAnvilBlockEntity.this.expLevel;
                }
                case 2: {
                    return AutoAnvilBlockEntity.this.xpEmptyBottleProgress;
                }
                case 3: {
                    return AutoAnvilBlockEntity.this.xpEmptyBottleMaxProgress;
                }
                case 4: {
                    return AutoAnvilBlockEntity.this.processProgress;
                }
                case 5: {
                    return AutoAnvilBlockEntity.this.maxProcessProgress;
                }
                case 6: {
                    return AutoAnvilBlockEntity.this.mode;
                }
                case 7: {
                    return AutoAnvilBlockEntity.this.levelCost;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 6) {
                AutoAnvilBlockEntity.this.mode = value;
            }
        }

        public int method_17389() {
            return PROPERTY_DELEGATE_SIZE;
        }
    };

    public AutoAnvilBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.random = new Random();
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        super.method_11014(nbt, wrapperLookup);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)wrapperLookup);
        this.xpEmptyBottleProgress = nbt.method_10550("XpEmptyBottleProgress");
        this.xpEmptyBottleMaxProgress = nbt.method_10550("XpEmptyBottleMaxProgress");
        if (this.xpEmptyBottleMaxProgress == 0) {
            this.xpEmptyBottleMaxProgress = 20;
        }
        this.expLevel = nbt.method_10550("ExpLevel");
        this.expProgress = nbt.method_10583("ExpProgress");
        this.processProgress = nbt.method_10550("ProcessProgress");
        this.maxProcessProgress = nbt.method_10550("MaxProcessProgress");
        if (this.maxProcessProgress == 0) {
            this.maxProcessProgress = 60;
        }
        this.mode = nbt.method_10550("Mode");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        super.method_11007(nbt, wrapperLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)wrapperLookup);
        nbt.method_10569("XpEmptyBottleProgress", this.xpEmptyBottleProgress);
        nbt.method_10569("XpEmptyBottleMaxProgress", this.xpEmptyBottleMaxProgress);
        nbt.method_10569("ExpLevel", this.expLevel);
        nbt.method_10548("ExpProgress", this.expProgress);
        nbt.method_10569("ProcessProgress", this.processProgress);
        nbt.method_10569("MaxProcessProgress", this.maxProcessProgress);
        nbt.method_10569("Mode", this.mode);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, AutoAnvilBlockEntity blockEntity) {
        if (blockEntity.processProgress > 0) {
            ++blockEntity.processProgress;
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AutoAnvilBlockEntity blockEntity) {
        boolean toMarkDirty = false;
        class_1799 expBottlesStack = (class_1799)blockEntity.inventory.get(SLOT_EXP_BOTTLE);
        class_1799 emptyBottlesStack = (class_1799)blockEntity.inventory.get(SLOT_EMPTY_BOTTLE);
        if (!expBottlesStack.method_7960() && expBottlesStack.method_31574(class_1802.field_8287) && (emptyBottlesStack.method_7960() || emptyBottlesStack.method_31574(class_1802.field_8469) && emptyBottlesStack.method_7947() < emptyBottlesStack.method_7914())) {
            ++blockEntity.xpEmptyBottleProgress;
            if (blockEntity.xpEmptyBottleProgress >= blockEntity.xpEmptyBottleMaxProgress) {
                blockEntity.addExperience(Math.round(8.0f));
                expBottlesStack.method_7934(1);
                if (emptyBottlesStack.method_7960()) {
                    emptyBottlesStack = new class_1799((class_1935)class_1802.field_8469);
                } else {
                    emptyBottlesStack.method_7933(1);
                }
                blockEntity.inventory.set(SLOT_EMPTY_BOTTLE, (Object)emptyBottlesStack);
                blockEntity.xpEmptyBottleProgress = 0;
                toMarkDirty = true;
            }
        } else {
            blockEntity.xpEmptyBottleProgress = 0;
        }
        class_1799 input = blockEntity.method_5438(SLOT_ITEM_IN);
        class_1799 addition = blockEntity.method_5438(SLOT_ITEM_ADD);
        if (blockEntity.lastMode != blockEntity.mode || blockEntity.lastInputStack == null || blockEntity.lastInputStack.method_7960() != input.method_7960() || blockEntity.lastInputStack.method_7909() != input.method_7909() || blockEntity.lastInputStack.method_7947() != input.method_7947() || blockEntity.lastAdditionStack == null || blockEntity.lastAdditionStack.method_7960() != addition.method_7960() || blockEntity.lastAdditionStack.method_7909() != addition.method_7909() || blockEntity.lastAdditionStack.method_7947() != addition.method_7947() || blockEntity.result == null) {
            blockEntity.lastInputStack = input.method_7972();
            blockEntity.lastAdditionStack = addition.method_7972();
            blockEntity.lastMode = blockEntity.mode;
            class_1799 resultBefore = blockEntity.result == null ? null : blockEntity.result.method_7972();
            blockEntity.updateResult();
            if (resultBefore == null || blockEntity.result.method_7960() != resultBefore.method_7960() || blockEntity.result.method_7909() != resultBefore.method_7909() || resultBefore.method_7919() != blockEntity.result.method_7919() || resultBefore.method_57824(class_9334.field_49639) != blockEntity.result.method_57824(class_9334.field_49639)) {
                blockEntity.processProgress = 0;
            }
        }
        class_1799 anvilStack = blockEntity.method_5438(SLOT_ANVIL);
        if (!blockEntity.result.method_7960() && blockEntity.levelCost <= blockEntity.expLevel && blockEntity.method_5438(SLOT_ITEM_OUT).method_7960() && (anvilStack.method_31574(class_1802.field_8782) || anvilStack.method_31574(class_1802.field_8750) || anvilStack.method_31574(class_1802.field_8427))) {
            ++blockEntity.processProgress;
            if (blockEntity.processProgress == 1) {
                toMarkDirty = true;
            }
            if (blockEntity.processProgress == blockEntity.maxProcessProgress - 15) {
                world.method_8396(null, pos, class_3417.field_14559, class_3419.field_15245, 0.3f, world.field_9229.method_43057() * 0.1f + 0.9f);
            }
            if (blockEntity.processProgress >= blockEntity.maxProcessProgress) {
                blockEntity.doProcess();
                blockEntity.processProgress = 0;
                toMarkDirty = true;
            }
        } else {
            blockEntity.processProgress = 0;
        }
        if (toMarkDirty) {
            blockEntity.method_5431();
        }
    }

    public void doProcess() {
        this.addExperienceLevels(-this.levelCost.intValue());
        if (this.random.nextFloat() < 0.12f / (float)this.method_5438(SLOT_ANVIL).method_7947()) {
            this.damageAnvilItem();
        }
        this.method_5447(SLOT_ITEM_IN, class_1799.field_8037);
        if (this.mode == MODE_REPAIR) {
            if (this.repairItemUsage > 0) {
                class_1799 additionStack = this.method_5438(SLOT_ITEM_ADD);
                if (!additionStack.method_7960() && additionStack.method_7947() > this.repairItemUsage) {
                    additionStack.method_7934(this.repairItemUsage.intValue());
                    this.method_5447(SLOT_ITEM_ADD, additionStack);
                } else {
                    this.method_5447(SLOT_ITEM_ADD, class_1799.field_8037);
                }
            } else {
                this.method_5447(SLOT_ITEM_ADD, class_1799.field_8037);
            }
        }
        this.method_5447(SLOT_ITEM_OUT, this.result.method_7972());
    }

    public void damageAnvilItem() {
        class_1799 anvilStack = this.method_5438(SLOT_ANVIL);
        if (anvilStack.method_31574(class_1802.field_8427)) {
            this.method_5447(SLOT_ANVIL, class_1799.field_8037);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14665, class_3419.field_15245, 0.3f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
            return;
        }
        if (anvilStack.method_31574(class_1802.field_8782)) {
            this.method_5447(SLOT_ANVIL, new class_1799((class_1935)class_1802.field_8750, anvilStack.method_7947()));
        }
        if (anvilStack.method_31574(class_1802.field_8750)) {
            this.method_5447(SLOT_ANVIL, new class_1799((class_1935)class_1802.field_8427, anvilStack.method_7947()));
        }
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14542, class_3419.field_15245, 0.3f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateResult() {
        Map<class_6880<class_1887>, Integer> map;
        class_1799 additionStack;
        int levelCost3;
        int levelCost2;
        int levelCost1;
        block26: {
            block27: {
                block24: {
                    int damage3;
                    int damage2;
                    int damage1;
                    boolean enchantedBookInAdditionSlot;
                    block25: {
                        this.levelCost = 0;
                        this.result = this.method_5438(SLOT_ITEM_IN).method_7972();
                        this.repairItemUsage = 0;
                        levelCost1 = 0;
                        levelCost2 = 0;
                        levelCost3 = 0;
                        if (this.result.method_7960()) {
                            return;
                        }
                        additionStack = this.method_5438(SLOT_ITEM_ADD).method_7972();
                        map = this.map(this.result);
                        levelCost2 += (Integer)this.result.method_57824(class_9334.field_49639) + (additionStack.method_7960() ? 0 : (Integer)additionStack.method_57824(class_9334.field_49639));
                        if (this.mode != MODE_REPAIR) break block24;
                        if (additionStack.method_7960()) {
                            this.result = class_1799.field_8037;
                            return;
                        }
                        boolean bl = enchantedBookInAdditionSlot = additionStack.method_31574(class_1802.field_8598) && (additionStack.method_57826(class_9334.field_49633) || additionStack.method_57826(class_9334.field_49643));
                        if (!this.result.method_7963() || !this.result.method_7909().method_7878(this.result, additionStack)) break block25;
                        damage1 = Math.min(this.result.method_7919(), this.result.method_7936() / 4);
                        if (damage1 <= 0) {
                            this.result = class_1799.field_8037;
                            return;
                        }
                        for (damage2 = 0; damage1 > 0 && damage2 < additionStack.method_7947(); ++levelCost1, ++damage2) {
                            damage3 = this.result.method_7919() - damage1;
                            this.result.method_7974(damage3);
                            damage1 = Math.min(this.result.method_7919(), this.result.method_7936() / 4);
                        }
                        this.repairItemUsage = damage2;
                        break block26;
                    }
                    if (!(enchantedBookInAdditionSlot || this.result.method_31574(additionStack.method_7909()) && this.result.method_7963())) {
                        this.result = class_1799.field_8037;
                        return;
                    }
                    if (!this.result.method_7963() || enchantedBookInAdditionSlot) break block27;
                    damage1 = this.result.method_7936() - this.result.method_7919();
                    damage2 = additionStack.method_7936() - additionStack.method_7919();
                    damage3 = damage2 + this.result.method_7936() * 12 / 100;
                    int damage4 = damage1 + damage3;
                    int damage5 = this.result.method_7936() - damage4;
                    if (damage5 < 0) {
                        damage5 = 0;
                    }
                    if (damage5 >= this.result.method_7919()) break block27;
                    this.result.method_7974(damage5);
                    levelCost1 += 2;
                    break block27;
                }
                if (this.mode != MODE_RENAME) break block26;
                String newName = "";
                if (!additionStack.method_7960()) {
                    newName = additionStack.method_7964().getString();
                }
                if (StringUtils.isBlank((CharSequence)newName)) {
                    if (this.result.method_57826(class_9334.field_49631)) {
                        levelCost3 = 1;
                        levelCost1 += levelCost3;
                        this.result.method_57381(class_9334.field_49631);
                    }
                    break block26;
                } else if (!newName.equals(this.result.method_7964().getString())) {
                    levelCost3 = 1;
                    levelCost1 += levelCost3;
                    this.result.method_57379(class_9334.field_49631, (Object)TextUtil.literalText(newName));
                }
                break block26;
            }
            Map<class_6880<class_1887>, Integer> map2 = this.map(additionStack);
            boolean bl2 = false;
            boolean bl3 = false;
            Iterator<class_6880<class_1887>> var23 = map2.keySet().iterator();
            while (true) {
                int r;
                if (!var23.hasNext()) {
                    if (!bl3 || bl2) break;
                    this.result = class_1799.field_8037;
                    this.levelCost = 0;
                    return;
                }
                class_6880<class_1887> enchantment = var23.next();
                if (enchantment == null) continue;
                int q = map.getOrDefault(enchantment, 0);
                r = q == (r = map2.get(enchantment).intValue()) ? r + 1 : Math.max(r, q);
                boolean bl4 = ((class_1887)enchantment.comp_349()).method_8192(this.result);
                if (this.result.method_31574(class_1802.field_8598)) {
                    bl4 = true;
                }
                for (class_6880<class_1887> enchantment2 : map.keySet()) {
                    if (enchantment2 == enchantment || class_1887.method_60033(enchantment, enchantment2)) continue;
                    bl4 = false;
                    ++levelCost1;
                }
                if (!bl4) {
                    bl3 = true;
                    continue;
                }
                bl2 = true;
                if (r > ((class_1887)enchantment.comp_349()).method_8183()) {
                    r = ((class_1887)enchantment.comp_349()).method_8183();
                }
                map.put(enchantment, r);
                levelCost1 += r;
                if (this.result.method_7947() <= 1) continue;
                levelCost1 = 40;
            }
        }
        this.levelCost = levelCost2 + levelCost1;
        if (levelCost1 <= 0) {
            this.result = class_1799.field_8037;
        }
        if (levelCost3 == levelCost1 && levelCost3 > 0 && this.levelCost >= 40) {
            this.levelCost = 39;
        }
        if (this.levelCost >= 40) {
            this.result = class_1799.field_8037;
        }
        if (!this.result.method_7960()) {
            int t = (Integer)this.result.method_57824(class_9334.field_49639);
            if (!additionStack.method_7960() && t < (Integer)additionStack.method_57824(class_9334.field_49639)) {
                t = (Integer)additionStack.method_57824(class_9334.field_49639);
            }
            if (levelCost3 != levelCost1 || levelCost3 == 0) {
                t = class_1706.method_20398((int)t);
            }
            this.result.method_57379(class_9334.field_49639, (Object)t);
            class_9304.class_9305 builder = new class_9304.class_9305(this.result.method_58657());
            for (Map.Entry<class_6880<class_1887>, Integer> e : map.entrySet()) {
                builder.method_57550(e.getKey(), e.getValue().intValue());
            }
            class_1890.method_57530((class_1799)this.result, (class_9304)builder.method_57549());
        }
    }

    public Map<class_6880<class_1887>, Integer> map(class_1799 stack) {
        HashMap map = Maps.newHashMap();
        for (Object2IntMap.Entry e : class_1890.method_57532((class_1799)stack).method_57539()) {
            map.put((class_6880)e.getKey(), e.getIntValue());
        }
        return map;
    }

    public void addExperience(int experience) {
        this.expProgress += (float)experience / (float)this.getNextLevelExperience();
        while (this.expProgress < 0.0f) {
            float f = this.expProgress * (float)this.getNextLevelExperience();
            if (this.expLevel > 0) {
                this.addExperienceLevels(-1);
                this.expProgress = 1.0f + f / (float)this.getNextLevelExperience();
                continue;
            }
            this.addExperienceLevels(-1);
            this.expProgress = 0.0f;
        }
        while (this.expProgress >= 1.0f) {
            this.expProgress = (this.expProgress - 1.0f) * (float)this.getNextLevelExperience();
            this.addExperienceLevels(1);
            this.expProgress /= (float)this.getNextLevelExperience();
        }
    }

    public void addExperienceLevels(int levels) {
        this.expLevel += levels;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.expProgress = 0.0f;
        }
    }

    public int getNextLevelExperience() {
        if (this.expLevel >= 30) {
            return 112 + (this.expLevel - 30) * 9;
        }
        if (this.expLevel >= 15) {
            return 37 + (this.expLevel - 15) * 5;
        }
        return 7 + this.expLevel * 2;
    }

    public class_2561 method_5476() {
        return TextUtil.translatableText(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AutoAnvilScreenHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.inventory.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 || dir == class_2350.field_11033) {
            return slot == SLOT_ITEM_IN && this.method_5438(slot).method_7960();
        }
        if (stack.method_31574(class_1802.field_8287)) {
            return slot == SLOT_EXP_BOTTLE;
        }
        if (stack.method_31574(class_1802.field_8782) || stack.method_31574(class_1802.field_8750) || stack.method_31574(class_1802.field_8427)) {
            return slot == SLOT_ANVIL && this.method_5438(slot).method_7960();
        }
        return slot == SLOT_ITEM_ADD;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == SLOT_EMPTY_BOTTLE || slot == SLOT_ITEM_OUT;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.inventory) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        if (amount == ((class_1799)this.inventory.get(slot)).method_7947()) {
            return this.method_5441(slot);
        }
        class_1799 toRet = ((class_1799)this.inventory.get(slot)).method_7972();
        ((class_1799)this.inventory.get(slot)).method_7934(amount);
        toRet.method_7939(amount);
        return toRet;
    }

    public class_1799 method_5441(int slot) {
        class_1799 toRet = ((class_1799)this.inventory.get(slot)).method_7972();
        this.inventory.set(slot, (Object)class_1799.field_8037);
        return toRet;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_5431() {
        boolean serverSide = this.method_11002() && !this.method_10997().method_8608();
        super.method_5431();
        if (serverSide) {
            ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void dropXP() {
        int amt = this.expLevel * 7;
        amt = Math.min(amt, 100);
        class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.field_11867), (int)amt);
    }
}

